package ch.frankel.blog.hibernate.model;

import static javax.persistence.GenerationType.AUTO;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;

/**
 * An account.
 * 
 * @author Nicolas Frnkel
 * @since 21 juin 2009
 */
@Entity
public class Account {

    @Id
    @GeneratedValue(strategy = AUTO)
    private long id;

    @Column(nullable = false, length = 16)
    private String iban;

    @ManyToMany
    @JoinTable(name = "ACCOUNT_CUSTOMER", joinColumns = @JoinColumn(name = "ACCOUNT_ID", nullable = false),
    		inverseJoinColumns = @JoinColumn(name = "CUSTOMER_ID", nullable = false))
    private Set<Customer> customers;

    public Set<Customer> getCustomers() {

        return customers;
    }

    public String getIban() {

        return iban;
    }

    public void setCustomers(Set<Customer> aCustomers) {

        customers = aCustomers;
    }

    public void setIban(String aIban) {

        iban = aIban;
    }

    public long getId() {

        return id;
    }

    public void setId(long aId) {

        id = aId;
    }

    /**
     * Adds a customer to this account's. Manage bidirectional associations.
     * 
     * @param customer
     */
    public void addCustomer(Customer customer) {

        getCustomers().add(customer);
        customer.getAccounts().add(this);
    }

    /**
     * Removes a customer to this account's. Manage bidirectional associations.
     * 
     * @param customer
     */
    public void removeAccount(Customer customer) {

        getCustomers().remove(customer);
        customer.getAccounts().remove(this);
    }

}
